﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;







/*  
 
 A State Machine workflow
 
 The state machine in this example has 4 states.
 
 Each state contains a StateInitializationActivity and a StateFinalizationActivity
 which provide information on screen about the current state.
 
 Each state asks for a number between 0 and 9 and checks the input using an IfElseActivity
 with two IfElseBranchActivity branches.
 
 If the N number is less than 5 then it goes on to the next state, else it goes back
 to a previous state.
 
 Also each state contains an EventDrivenActivity which is the parent of the  
 IfElseActivity with the two IfElseBranchActivity branches where each branch leads to
 a different SetStateActivity according the number condition evaluation.
 
 No declarative code is used in this example.
 
 */
namespace Lessons.Workflows
{
    public sealed partial class Workflow1 : StateMachineWorkflowActivity
    {
        public Workflow1()
        {
            InitializeComponent();
        }

        private void AnyStateInitialization_ExecuteCode(object sender, EventArgs e)
        {
            Console.WriteLine("(" + CurrentStateName + ") : Enter a number between 0 and 9...");
        }

        private void AnyStateFinalization_ExecuteCode(object sender, EventArgs e)
        {
            Console.WriteLine("(" + CurrentStateName + ") : finalization");
            Console.WriteLine("------------------------------------------");
        }

        int N = 0;

        private void NumberInput_ExecuteCode(object sender, EventArgs e)
        {
            N = int.Parse(Console.ReadLine());
        }

        void NumberLess_Condition(object sender, ConditionalEventArgs e)
        {
            e.Result = N < 5;
        }


    }
}
